<?php
session_start();
include "../connection.php"; 

if (!isset($_SESSION['userid'])) {
    if (isset($_COOKIE['userid'])) {
        $_SESSION['userid'] = $_COOKIE['userid'];
    } else {
        header("Location: ../login.php");
        exit();
    }
}

// Fetch the user ID from the session
$userid = $_SESSION['userid'];

// Handle form submission to update notification status
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['NoticeUp'])) {
    $notificationId = $_POST['NtId'];
    
    // Prepare update statement
    $updateSql = "UPDATE notification SET status='Read' WHERE id=? AND userid=?";
    $updateStmt = $con->prepare($updateSql);
    $updateStmt->bind_param("ii", $notificationId, $userid);
    $updateStmt->execute();
    $updateStmt->close();
}

// Fetch unread notifications
$sql = "SELECT id, date, message FROM notification WHERE status='Unread' AND userid=? ORDER BY date DESC";
$stmt = $con->prepare($sql);
$stmt->bind_param("i", $userid);
$stmt->execute();
$stmt->bind_result($id, $date, $message);

// Store notifications in an array
$notifications = [];
while ($stmt->fetch()) {
    $notifications[] = [
        'id' => $id,
        'date' => $date,
        'message' => $message,
    ];
}
$stmt->close();
?>

<?php include 'header-link.php' ?>

<main>
    <?php include 'top-bar.php' ?>
    <section>
        <div class="container mt-2 pb-5">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card custom-card">
                        <div class="card-body">
                            <div class="text-center">
                                <i class="profile-icon fa-sharp-duotone fa-solid fa-flag-checkered"></i>
                            </div>
                            <h6 class="card-title text-center my-3">নোটিশ</h6>
							
							 <div class="offer-list" id="offerList">
                                <?php $sql = "
								SELECT * FROM notify_user
								ORDER BY id DESC LIMIT 1";
								$result = $con->query($sql); ?>
								<?php if ($result->num_rows > 0): ?>
									 <?php while($row = $result->fetch_assoc()): ?>
                                    <div class="offer-card mb-3 p-4">
									 
                                        <div class="row">
                                            <div class="col-12 text-left">
                                                <small>
                                                    <u class="fw-bold"> এডমিন নোটিশ - <?php echo date('d-m-Y', strtotime($row['date'])); ?></u>
                                                </small><br>
                                                <small><?php echo htmlspecialchars($row['message']); ?></small><br>
                                            </div>
                                            
                                        </div>
                                    </div>
                                 <?php endwhile; ?>
                                <?php else: ?>
									<small>No Admin Notice found.</small>
									<?php endif; ?>
                            </div>

                            <div class="offer-list" id="offerList">
                                <?php foreach ($notifications as $notification): ?>
                                    <div class="offer-card mb-3 p-4">
                                        <div class="row">
                                            <div class="col-10 text-left">
                                                <small>
                                                    <u class="fw-bold"><?php echo date('d-m-Y', strtotime($notification['date'])); ?></u>
                                                </small><br>
                                                <small><?php echo htmlspecialchars($notification['message']); ?></small><br>
                                            </div>
                                            <div class="col-2 text-end">
                                               <form action="" method="POST">
                                                    <input type="hidden" name="NtId" value="<?php echo htmlspecialchars($notification['id']); ?>">
                                                    <button name="NoticeUp" class="btn custom-button w-100 mx-auto"><i class="fa-solid fa-check-double"></i></button>
                                               </form>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>
</body>
</html>
